<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateOrderRequest;
use App\Http\Requests\Admin\StoreOrderRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\OrderOperations;
use Illuminate\Http\Request;
use App\Admin;
use App\Order;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        $orders = Order::latest();
        $search = array();
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $orders = $orders->where('id'  ,$id);
        }
        if (Request()->has('country') && Request()->get('country') != '') {
            $country = Request()->get('country');
            $search['country'] = $country;
            $orders = $orders->where('country' , 'LIKE' ,'%'.$country.'%');
        }
        if (Request()->has('city') && Request()->get('city') != '') {
            $city = Request()->get('city');
            $search['city'] = $city;
            $orders = $orders->where('city' , 'LIKE' ,'%'.$city.'%');
        }
        if (Request()->has('name') && Request()->get('name') != '') {
            $name = Request()->get('name');
            $search['name'] = $name;
            $orders = $orders->where('name' , 'LIKE' ,'%'.$name.'%');
        }
        if (Request()->has('excel') && Request()->get('excel') != '') {
            $orders = $orders->get();
            return Excel::download(new GeneralExport('admin.reports.orders-excel', $orders), 'orders-'.Carbon::now()->toDateString().'.xlsx');
        }
        $orders = $orders->paginate(40);
        $title = 'الطلبات';
              
        return view('admin.orders.index', compact('orders', 'title' ,'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة طلب';
        return view('admin.orders.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreOrderRequest $request)
    {
        $this->register($request);
        // return view('admin.orders.add');
        return redirect()->back()->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $item = Order::find($id);
        $title = 'عرض طلب';
        return view('admin.orders.show', compact('item', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $order = Order::find($id);
        $title = 'تعديل طلب';
        return view('admin.orders.edit', compact('order', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      
        $order = Order::find($id);
        $ty = $request->ty;
        switch ($ty) {
            case 'emp':
                $order->Log()->create([
                    'content' => 'تم مراجعه صحه البيانات و المرفقات',
                    'user_id' => auth()->id(),
                ]);
                $order->update(['step1' => 1]);
                break;
            case 'review':
                $order->Log()->create([
                    'content' => 'تم تعميد المبلغ : '.$request->get('amount'),
                    'user_id' => auth()->id(),
                ]);
                $order->update(['step2' => 1, 'amount' => $request->get('amount')]);
                break;
            case 'adm':
                $order->Log()->create([
                    'content' => 'تم تسليم المساعدة',
                    'user_id' => auth()->id(),
                ]);
                $order->update(['step3' => 1]);
                break;
            
            default:
                # code...
                break;
        }
        return redirect()->back()->with('success', 'data updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Order $order)
    {
        $order->OrderLog()->delete();
        $order->Invoice()->delete();
        $order->delete();
        return 'success';
    }
    public function logout()
    {
        Auth::logout();
        return redirect('/login');
    }

    public function bill( $id){
        $order = Order::findOrfail($id);
        return view('admin.orders.print', compact('order'));
        
    }

    public function companyBill( $id){
        $order = Order::findOrfail($id);
        return view('company.orders.print', compact('order'));
        
    }

    public function UAll(Request $request){
        $order = Order::whereIn('id', $request->get('ids') )->update(['status' => $request->get('status')]);
        return redirect()->back()->with('success', 'data updated successfully');
        
    }
}
