<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Org</title>

    <!-- Favicons-->
    <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon">
    <link rel="apple-touch-icon" type="image/x-icon" href="img/apple-touch-icon-57x57-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="72x72" href="img/apple-touch-icon-72x72-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="114x114"
        href="img/apple-touch-icon-114x114-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="144x144"
        href="img/apple-touch-icon-144x144-precomposed.png">

    <!-- GOOGLE WEB FONT -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link
        href="https://fonts.googleapis.com/css2?family=Markazi+Text:wght@400;500;600&family=Tajawal:wght@300;400;500&display=swap"
        rel="stylesheet">

    <!-- BASE CSS -->
    <!-- <link href="css/bootstrap.min.css" rel="stylesheet"> -->
    <link href="/css/bootstraprtl.min.css" rel="stylesheet">
    <link href="/css/menu.css" rel="stylesheet">
    <link href="/css/style.css" rel="stylesheet">
    <link href="/css/vendors.css" rel="stylesheet">

    <!-- YOUR CUSTOM CSS -->
    <link href="/css/custom.css" rel="stylesheet">

    <link href="/css/essa.css" rel="stylesheet">
    <!-- MODERNIZR MENU -->
    <script src="/js/modernizr.js"></script>

</head>

<body dir="rtl">

    <div id="preloader">
        <div data-loader="circle-side"></div>
    </div>
    <!-- /Preload -->

    <div id="loader_form">
        <div data-loader="circle-side-2"></div>
    </div>
    <!-- /loader_form -->

    <header>
        <div class="container">
            <div class="row">
                <div class="col-3">
                    <a href="/"><img src="/img/info_graphic_1.svg" alt="" width="178" height="45" class="d-none d-md-block"><img
                            src="img/logo_mobile.svg" alt="" width="62" height="45" class="d-block d-md-none"></a>
                </div>
                <div class="col-9">
                    <div id="social">

                    </div>
                </div>
            </div>
        </div>
        <!-- /container -->
    </header>
    <!-- /Header -->

    <div class="container2">
        <div id="form_container">
            <div class="row no-gutters">
                <div class="col-lg-4">
                    <div id="left_form">
                        <figure><img src="img/info_graphic_1.svg" alt="" width="100" height="100"></figure>
                        <h2>الجمعيه الخيريه <span>لتقديم المساعدات</span></h2>
                        <p>يمكنك الاستعلام عن الطلب باستخدام الزر ادناه</p>
                        <a href="#0" class="btn_1 rounded yellow purchase"  data-toggle="modal" data-target="#more-info">استعلام عن الطلب</a>
                        <a href="#wizard_container" class="btn_1 rounded mobile_btn yellow" data-toggle="modal" data-target="#more-info">استعلام عن الطلب</a>
                        {{-- <a href="#0"><i
                                class="pe-7s-info"></i></a> --}}
                    </div>
                </div>
                <div class="col-lg-8">
                    <div id="wizard_container">
                        <div id="top-wizard">
                            <div id="progressbar"></div>
                            <span id="location"></span>
                        </div>
                        <!-- /top-wizard -->
                        <form id="wrapped" action="/add-app" method="post" enctype="multipart/form-data">
                            @csrf
                            <input id="website" name="website" type="text" value="">
                            <!-- Leave for security protection, read docs for details -->
                            <div id="middle-wizard">
                                <div class="step">
                                    <h3 class="main_question"><i class="arrow_right"></i>من فضلك ادخل بياناتك الشخصيه
                                    </h3>
                                    <div class="form-group add_top_30">
                                        <label for="name">الاسم</label>
                                        <input type="text" name="name" id="name" class="form-control required"
                                            onchange="getVals(this, 'name_field');">
                                    </div>
                                    <div class="row">


                                        <div class="col">
                                            <h6 class="mt-3">
                                                الجنس
                                            </h6>
                                            <div class="form-group radio_input">
                                                <label class="container_radio mr-3">ذكر
                                                    <input type="radio" name="gender" value="Male" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio">أنثي
                                                    <input type="radio" name="gender" value="Female" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="country"> الجنسية</label>
                                        <select class="form-control  required" id="country" name="country">
                                            @foreach (\App\City::where('type', 'country')->get() as $item)
                                            <option value="{{$item->name}}">{{$item->name}}</option>
                                                
                                            @endforeach

                                        </select>
                                    </div>

                                    <!-- /row-->
                                </div>

                                <div class="step">
                                    <!-- <h3 class="main_question"><i class="arrow_right"></i> المدينة</h3> -->

                                    <h3 class="main_question"><i class="arrow_right"></i>العنوان
                                    </h3>
                                    <div class="form-group">
                                        <label for="country"> المدينة</label>
                                        <select class="form-control  required" id="city" name="city">
                                            
                                            @foreach (\App\City::where('type', 'city')->get() as $item)
                                            <option value="{{$item->name}}">{{$item->name}}</option>
                                                
                                            @endforeach

                                        </select>
                                    </div>
                                    <!-- /row -->
                                    <div class="form-group ">
                                        <label for="hood">الحي</label>
                                        <input type="text" name="hood" id="hood" class="form-control required"
                                            onchange="getVals(this, 'name_field');">
                                    </div>

                                </div>
                                <!-- /step-->

                                <div class="step">
                                    <h3 class="main_question"><i class="arrow_right"></i>العنوان الوطني
                                    </h3>
                                    <div class="form-group ">

                                        <input type="file" name="adress_img" id="img-up"
                                            class="img-up form-control required custom-file-input  " accept="image/*">
                                        <label class="custom-file-label" for="adress">ادخل صوره من العنوان
                                            الوطني</label>
                                        <div class="img-wr mb-3">
                                            <img id="blah" src="#" alt=""
                                                onerror="this.onerror=null; this.src='img/default.png'" />
                                        </div>
                                    </div>

                                    <h3 class="main_question"><i class="arrow_right"></i> الهوية
                                    </h3>
                                    <div class="form-group">
                                        <label for="id-num">رقم الهوية</label>
                                        <input type="text" name="id_num" id="id-num" class="form-control required">
                                    </div>

                                    <div class="form-group">
                                        <label for="id-date">تاريخ انتهاء الهوية</label>
                                        <input type="text" name="id_date" id="id-date" class="form-control required">
                                    </div>

                                    <div class="form-group ">

                                        <input type="file" name="id_date_pic" id="img-up"
                                            class="img-up form-control  required custom-file-input " accept="image/*">
                                        <label class="custom-file-label" for="id-date-pic">ادخل صوره من موقع ابشر توضح
                                            تاريخ
                                            الانتهاء</label>
                                        <div class="img-wr mb-3">
                                            <img id="blah" src="#" alt=""
                                                onerror="this.onerror=null; this.src='img/default.png'" />
                                        </div>
                                    </div>

                                </div>
                                <!-- /step-->


                                <div class="step">
                                    <h3 class="main_question"><i class="arrow_right"></i>الهاتف
                                    </h3>
                                    <div class="form-group">
                                        <label for="phone1">رقم الجوال 1</label>
                                        <input type="text" name="phone1" id="phone1" class="form-control required">
                                    </div>
                                    <div class="form-group">
                                        <label for="phone2">رقم الجوال 2</label>
                                        <input type="text" name="phone2" id="phone2" class="form-control">
                                    </div>



                                    <h3 class="main_question"><i class="arrow_right"></i> تاريخ الميلاد
                                    </h3>
                                    <div class="form-group">
                                        <label for="birth-date"> ادخل تاريخ الميلاد </label>
                                        <input type="text" name="birth_date" id="birth-date"
                                            class=" form-control required">
                                    </div>

                                    <h3 class="main_question"><i class="arrow_right"></i> الحالة الاجتماعبة
                                    </h3>
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <label class="container_radio version_2">أرملة
                                                    <input type="radio" name="status" value="wido" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2">مطلقة
                                                    <input type="radio" name="status" value="divo" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2">مهجورة
                                                    <input type="radio" name="status" value="aban" class="required">
                                                    <span class="checkmark"></span>
                                                </label>

                                            </div>
                                            <div class="col-lg-6">
                                                <label class="container_radio version_2">عائلة سجين
                                                    <input type="radio" name="status" value="pris" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2 ">رب أسره
                                                    <input type="radio" name="status" value="fam" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2">مرافق
                                                    <input type="radio" name="status" value="with" class="required">
                                                    <span class="checkmark"></span>
                                                </label>

                                            </div>
                                        </div>



                                    </div>





                                </div>

                                <!-- /step-->



                                <div class="step">
                                    <h3 class="main_question"><i class="arrow_right"></i>المعالين
                                    </h3>
                                    <items>
                                        <item class="hidden"
                                            style="border: 1px solid #000; overflow: hidden; display: block; padding: 8px; margin-bottom: 5px;">

                                            <div class="form-group">
                                                <label for="f-name">اسم المعال</label>
                                                <input type="text" name="persons[][name]" id="f-name"
                                                    class="p-n form-control ">
                                            </div>
                                            <div class="form-group">
                                                {{-- <h6> صلة القرابة</h6> --}}
                                                <div class="form-group">
                                                    <label for="relation"> صلة القرابة</label>
                                                    <select class="form-control p-r " id="relation"  name="persons[][relation]">
                                                        <option value="أب">أب</option>
                                                        <option value="أم">أم</option>
                                                        <option value="ابن">ابن</option>
                                                        <option value="ابنه">ابنه</option>
                                                        <option value="زوجه">زوجه</option>
                                                        <option value="زوج">زوج</option>
            
                                                    </select>
                                                </div>



                                            </div>

                                            <div class="form-group">
                                                <label for="f-id-num">رقم هوية المعال</label>
                                                <input type="text" name="persons[][id_num]" id="f-id-num"
                                                    class="p-i form-control ">
                                            </div>


                                            <div class="form-group ">

                                                <input type="file" name="persons[][id_pic]" id="img-up"
                                                    class="img-up form-control  custom-file-input p-p "
                                                    accept="image/*">
                                                <label class="custom-file-label" for="f-id">ادخل صوره هوية المعال
                                                </label>
                                                <div class="img-wr mb-3">
                                                    <img id="blah" src="#" alt=""
                                                        onerror="this.onerror=null; this.src='img/default.png'" />
                                                </div>
                                            </div>


                                            <div class="form-group">
                                                <label for="income"> مبلغ الدخل</label>
                                                <input type="text" name="persons[][income]" id="income"
                                                    class="p-ii form-control ">
                                            </div>
                                            <button type="button" class="btn btn-danger r"
                                                style="width: 100%;">حذف</button>
                                        </item>

                                    </items>
                                    <button type="button" class="btn btn-primary a-n" style="width: 100%;">اضافة
                                        معال</button>
                                    <br>


                                </div>
                                <!-- /step-->
                                <div class="step">
                                    <h3 class="main_question"><i class="arrow_right"></i>الدخل الشهري للمستفيد
                                    </h3>
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <label class="container_radio version_2">الراتب
                                                    <input type="radio" name="money" value="sal" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2">حساب المواطن
                                                    <input type="radio" name="money" value="acc" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2">الضمان الاجتماعي
                                                    <input type="radio" name="money" value="sochial" class="required">
                                                    <span class="checkmark"></span>
                                                </label>

                                            </div>
                                            <div class="col-lg-6">
                                                <label class="container_radio version_2">التقاعد
                                                    <input type="radio" name="money" value="ret" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2 ">التأهيل الشامل
                                                    <input type="radio" name="money" value="mass" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2">أخرى
                                                    <input type="radio" name="money" value="other" class="required">
                                                    <span class="checkmark"></span>
                                                </label>

                                            </div>
                                        </div>



                                    </div>

                                    <h3 class="main_question"><i class="arrow_right"></i>طبيعة السكن
                                    </h3>
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <label class="container_radio version_2">ملك
                                                    <input type="radio" name="house" value="own" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2">ايجار
                                                    <input type="radio" name="house" value="rent" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2"> شعبي
                                                    <input type="radio" name="house" value="pub" class="required">
                                                    <span class="checkmark"></span>
                                                </label>

                                            </div>
                                            <div class="col-lg-6">
                                                <label class="container_radio version_2">رباط
                                                    <input type="radio" name="house" value="rebat" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2 "> مع الاسرة
                                                    <input type="radio" name="house" value="withfam" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2">أخرى
                                                    <input type="radio" name="house" value="houseother"
                                                        class="required">
                                                    <span class="checkmark"></span>
                                                </label>

                                            </div>
                                        </div>



                                    </div>

                                    <h3 class="main_question"><i class="arrow_right"></i> الحالة الصحية
                                    </h3>
                                    <div class="form-group">
                                        <label class="container_radio version_2">سليم
                                            <input type="radio" name="health" value="well" class="required">
                                            <span class="checkmark"></span>
                                        </label>
                                        <label class="container_radio version_2">امراض مزمنة تعيق عن العمل
                                            <input type="radio" name="health" value="halfill" class="required">
                                            <span class="checkmark"></span>
                                        </label>
                                        <label class="container_radio version_2">امراض مزمنة لا تعيق عن العمل
                                            <input type="radio" name="health" value="ill" class="required">
                                            <span class="checkmark"></span>
                                        </label>




                                    </div>



                                </div>
                                <!-- /step-->
                                <div class="step">
                                    <h3 class="main_question"><i class="arrow_right"></i> اختر نوع الطلب
                                    </h3>
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <label class="container_radio version_2">مساعدة ايجار
                                                    <input type="radio" name="req" value="1" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2">مساعدة علاج
                                                    <input type="radio" name="req" value="2" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2"> مساعدة زواج
                                                    <input type="radio" name="req" value="3" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2">مساعدة تعليم
                                                    <input type="radio" name="req" value="4" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                            </div>
                                            <div class="col-lg-6">
                                                <label class="container_radio version_2 "> مساعدة ديون
                                                    <input type="radio" name="req" value="5" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                                <label class="container_radio version_2 "> مساعدة كهرباء
                                                    <input type="radio" name="req" value="6" class="required">
                                                    <span class="checkmark"></span>
                                                </label>

                                                <label class="container_radio version_2">مساعدة ارزاق
                                                    <input type="radio" name="req" value="7" class="required">
                                                    <span class="checkmark"></span>
                                                </label>

                                            </div>
                                        </div>

                                    </div>



                                </div>


                                <!-- /step-->
                                <div class="step req-t">

                                    <h3 class="main_question"><i class="arrow_right"></i> مساعدة الإيجار
                                    </h3>


                                    <div class="form-group">
                                        <label for="rentval">مبلغ الإيجار السنوي</label>
                                        <input type="text" name="rent_rentval" id="rentval"
                                            class="form-control required">
                                    </div>
                                    <div class="form-group">
                                        <label for="laterentval">مبلغ المتأخرات </label>
                                        <input type="text" name="rent_laterentval" id="laterentval"
                                            class="form-control required">
                                    </div>
                                    <div class="form-group">
                                        <label for="ownernum"> رقم صاحب العقار </label>
                                        <input type="text" name="rent_ownernum" id="ownernum"
                                            class="form-control required">
                                    </div>


                                    <div class="form-group ">

                                        <input type="file" name="rent_f_id" id="img-up"
                                            class="img-up form-control required custom-file-input  " accept="image/*">
                                        <label class="custom-file-label" for="f-id">ادخل صوره عقد الإيجار
                                        </label>
                                        <div class="img-wr mb-3">
                                            <img id="blah" src="#" alt=""
                                                onerror="this.onerror=null; this.src='img/default.png'" />
                                        </div>
                                    </div>


                                    <div class="form-group ">

                                        <input type="file" name="rent_latereq" id="img-up"
                                            class="img-up form-control  custom-file-input  " accept="image/*">
                                        <label class="custom-file-label" for="latereq">ادخل صورة من خطاب مطالبة
                                            بالمتأخرات
                                        </label>
                                        <div class="img-wr mb-3">
                                            <img id="blah" src="#" alt=""
                                                onerror="this.onerror=null; this.src='img/default.png'" />
                                        </div>
                                    </div>



                                </div>











                                <!-- /step-->

                                <div class="submit step" id="end">
                                    <div class="summary">
                                        <div class="wrapper">
                                            <h3>تاكيد الطلب<br><span id="name_field"></span>!</h3>
                                        </div>
                                        <div class="text-center">
                                            <div class="form-group terms">
                                                <label class="container_check">اوافق بان البيانات التي تم اضافتها حقيقيه
                                                    <input type="checkbox" name="terms" value="Yes" class="required">
                                                    <span class="checkmark"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- /step last-->

                            </div>
                            <!-- /middle-wizard -->
                            <div id="bottom-wizard">
                                <button type="button" name="backward" class="backward">السابق</button>
                                <button type="button" name="forward" class="forward">التالي</button>
                                <button type="submit" name="process" class="submit">ارسال</button>
                            </div>
                            <!-- /bottom-wizard -->
                        </form>
                    </div>
                    <!-- /Wizard container -->
                </div>
            </div>
            <!-- /Row -->
        </div>
        <!-- /Form_container -->
    </div>
    <!-- /container -->

    <div class="container">
        <footer id="home" class="clearfix">
        </footer>
        <!-- end footer-->
    </div>
    <!-- /container -->

    <div class="cd-overlay-nav">
        <span></span>
    </div>
    <!-- /cd-overlay-nav -->
    <div class="cd-overlay-content">
        <span></span>
    </div>
    <!-- /cd-overlay-content -->

    <!-- Modal terms -->
    <div class="modal fade" id="terms-txt" tabindex="-1" role="dialog" aria-labelledby="termsLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="termsLabel">Terms and conditions</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                </div>
                <div class="modal-body">
                    <p>Lorem ipsum dolor sit amet, in porro albucius qui, in <strong>nec quod novum accumsan</strong>,
                        mei ludus tamquam dolores id. No sit debitis meliore postulant, per ex prompta alterum sanctus,
                        pro ne quod dicunt sensibus.</p>
                    <p>Lorem ipsum dolor sit amet, in porro albucius qui, in nec quod novum accumsan, mei ludus tamquam
                        dolores id. No sit debitis meliore postulant, per ex prompta alterum sanctus, pro ne quod dicunt
                        sensibus. Lorem ipsum dolor sit amet,
                        <strong>in porro albucius qui</strong>, in nec quod novum accumsan, mei ludus tamquam dolores
                        id. No sit debitis meliore postulant, per ex prompta alterum sanctus, pro ne quod dicunt
                        sensibus.</p>
                    <p>Lorem ipsum dolor sit amet, in porro albucius qui, in nec quod novum accumsan, mei ludus tamquam
                        dolores id. No sit debitis meliore postulant, per ex prompta alterum sanctus, pro ne quod dicunt
                        sensibus.
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn_1" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->

    <!-- Modal info -->
    <div class="modal fade bd-example-modal-lg" id="more-info" tabindex="-1" role="dialog" aria-labelledby="more-infoLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered  modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="more-infoLabel">اسعلام عن الطلب</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="/info" id="mod-c-f" method="get" style="width: 100%;">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="phone2">رقم الطلب</label>
                                    <input type="text" name="order" id="order" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-success">استعلام</button>
                            </div>
                        </form>
                    </div>
                    <div class="row">
                        <div class="col-md-12" id="mod-c">

                        </div>
                    </div>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->

    <!-- COMMON SCRIPTS -->
    <script src="/js/jquery-3.2.1.min.js"></script>
    <script src="/js/common_scripts.min.js"></script>
    <script src="/js/velocity.min.js"></script>
    <script src="/js/common_functions.js"></script>

    <!-- Wizard script-->
    <script src="/js/func_1.js"></script>
    <script src="/js/essa.js"></script>


</body>

</html>
