<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});
Route::post('add-app', 'OrderController@add');
Route::get('ajax/{type}', 'OrderController@gett');
Route::get('info/{order}', 'OrderController@gettt');
Route::get('result/{order}', 'OrderController@i');


Route::group(['namespace' =>'Admin'], function() {
    Route::get('/admin/login','AuthController@loginForm')->name('login');
    Route::post('/admin/login','AuthController@login');
    Route::group(['prefix' => 'dashboard', 'middleware' => 'auth:web'], function() {
        Route::get('/admin/logout','AuthController@logout')->name('logout');
        Route::get('/', 'HomeController@index')->name('dashboard.main');
        Route::resource('/users', 'UserController');
        Route::resource('/orders', 'OrderController');
        Route::resource('/cities', 'CityController');
        Route::resource('/countries', 'CountryController');
        Route::resource('/notes', 'NoteController');
    });
});