<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Note extends Model
{
    protected $table = 'logs';
	protected $guarded = ['id'];
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'order_id', 'user_id', 'content'
    ];

    /**
     * Get all of the posts that are assigned this tag.
     */
    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function Order()
    {
        return $this->belongsTo(Order::class, 'order_id');
    }
}
