<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\City;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class CityController extends Controller
{
    public function index()
    {
        $title = 'المدن';
            $cities = City::where('type', 'city')->latest();
            $cities = $cities->paginate(40);
            $ty = 'cities';
        return view('admin.cities.index', compact('cities', 'title', 'ty'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        $ty = 'cities';
        return view('admin.cities.add', compact('title', 'ty'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        City::create([
            'name' => $request->name,
            'type' => 'city'
        ]);
        return redirect('/dashboard/cities')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(City $city)
    {
        $title = 'عرض ';
        return view('admin.cities.show', compact('city', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $city = City::find($id);
        $title = 'تعديل ';
        $ty = 'cities';
        return view('admin.cities.edit', compact('city', 'title', 'ty'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      
        $city = City::find($id);
        $city->update($request->only(['name']));
      
        return redirect('dashboard/cities');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(City $city)
    {
        if ($city->form_image) {
            @unlink(public_path('/cdn/'.$city->form_image));
        }
        $city->delete();
        return 'success';
    }
}
