<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Order;
use App\OrderPerson;
use App\User;
use App\Note;
use DB;
use App\Notifications\AdminNotification; 
use Illuminate\Support\Arr;

class OrderController extends Controller
{
    public function add(Request $request)
    {
        $ids = Arr::pluck($request->persons, 'id_num');
        if (($key = array_search(null, $ids)) !== false) {
            unset($ids[$key]);
        }
        if ((Order::where('id_num', $request->id_num)->count() > 0) || (OrderPerson::where('i_d', $request->id_num)->count() > 0 )|| (Order::whereIn('id_num', $ids)->count() > 0) || (OrderPerson::whereIn('i_d', $ids)->count() > 0 ) ) {
            return redirect('req-failed');
        }
        DB::beginTransaction();
        $data = $request->all();
        $data['live_pic'] = $this->uploadImage($request->file('live_pic'));
        $data['id_date_pic'] = $this->uploadImage($request->file('id_date_pic'));
        $data['adress_img'] = $this->uploadImage($request->file('adress_img'));
        $data['rent_f_id'] = $this->uploadImage($request->file('rent_f_id'));
        $data['rent_latereq'] = $this->uploadImage($request->file('rent_latereq'));
        $order = Order::create($data);
        if ($request->has('persons') && is_array( $request->get('persons') ) && $request->get('persons') > 0 ) {
            $i = 0;
            foreach ($request->get('persons') as $key => $value) {
                if (!isset($value['name']) || !$value['name']) {
                    $i++;
                    continue;
                }
                $id_pic =  null;
                if (isset($request->persons[$i]['id_pic']) && $request->persons[$i]['id_pic']) {
                    # code...
                    $id_pic = $this->uploadImage($request->persons[$i]['id_pic']);
                }
                $order->OrderPerson()->create([
                    'name' => $value['name'], 
                    'relation' => $value['relation'], 
                    'i_d' => $value['id_num'], 
                    'id_pic' => $id_pic, 
                    'income' => $value['income'],
                ]);
                $i++;
            }
        }
        DB::commit();
        $title = "تم انشاء الطلب  #".$order->id;
        $lk = route('orders.show', $order->id);
        $user = User::first();
        $user->notify(new AdminNotification($title,$lk));
        return redirect('result/'.$order->id);
    }
    public function i($id)
    {
        $order = Order::find($id);
        return view('welcomei', compact('order'));
    }
    public function noi()
    {
        return view('welcomenoi');
    }
    public function uploadImage($file)
    {
        if (!$file) {
            return null;
        }
        $filename = rand(99999, 99999999) . time(). '.' . $file->getClientOriginalExtension();
        $file->move(public_path('/cdn'), $filename);
        // $profileimg  = $filename;
        return $filename;
    }
    public function gett($type)
    {
        return view($type)->render();
        switch ($type) {
            case 'rent':
                $i = 1;
                break;
            case 'rent':
                $i = 2;
                break;
            case 'rent':
                $i = 3;
                break;
            case 'rent':
                $i = 4;
                break;
            case 'rent':
                $i = 5;
                break;
            case 'rent':
                $i = 6;
                break;
            case 'rent':
                $i = 7;
                break;
            
            default:
                
                break;
        }
    }
    public function gettt(Request $request, $order)
    {
        
        $notes = Note::where('order_id', $order)->latest()->get();
        if ($request->has('ph') && $request->get('ph') != '') {
            $notes = Note::whereHas('Order', function($q)use($request){
                $q->where('phone1', $request->get('ph'))
                ->where('id_num', $request->get('id'));
            })
                            ->latest()->get();
        }
        $title = '';
        return view('admin.note.iindex', compact('notes', 'title'));
    }
}
