@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<div class="row">
                   <div class="col-sm-12 m-b-15">
                        <div class="btn-group pull-right m-t-15">
                            <a href="/dashboard/users/{{$user->id}}/edit" class="btn btn-info waves-effect w-md waves-light m-b-5">
                                <i class="fa fa-pencil m-r-5"></i>
                                <span>تعديل</span>
                            </a>

                            <a href="{{route('users.destroy',$user)}}" id="delete-btn" class="btn btn-info btn-danger waves-effect w-md waves-light m-b-5 m-l-5">
                                <i class="fa fa-remove"></i>
                                <span>حذف</span>
                            </a>
                        </div>
                        <h4 class="page-title"><i class="fa fa-home"></i>   {{ $user->name }} </h4>
                    </div>
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="panel panel-color panel-tabs panel-success">
                            <div class="panel-heading panel-heading-custom">
                                <ul class="nav nav-pills">
                                    <li class="active">
                                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                                    </li>
                                    {{--  <li class="">
                                        <a href="#navpills-2" data-toggle="tab" aria-expanded="false">المستندات</a>
                                    </li>
                                    <li class="">
                                        <a href="#navpills-3" data-toggle="tab" aria-expanded="false">الصور</a>
                                    </li>
                                    <li class="">
                                        <a href="#navpills-4" data-toggle="tab" aria-expanded="false">عقود الإيجار</a>
                                    </li>
                                    <li class="">
                                        <a href="#navpills-5" data-toggle="tab" aria-expanded="false">الملاحظات</a>
                                    </li>  --}}
                                </ul>
                            </div>
                            <div class="panel-body">
                                <div class="tab-content">
                                    <div id="navpills-1" class="tab-pane fade in active">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="4">البيانات الأساسية</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>الاسم</td>
                                                            <td>{{$user->name}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>البريد الالكتروني</td>
                                                            <td>{{$user->email}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>الصورة</td>
                                                            <td>
                                                            @if($user->image!=null)
                                                                    <img src="{{getImage($user->image)}}" style="width: 200px;">
                                                            @endif
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الجوال</td>
                                                            <td>{{$user->phone}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                            <div class="col-md-6">
                                                {{--  <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="4">بيانات أخرى</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>الطابق</td>
                                                            <td>1</td>
                                                        </tr>
                                                        <tr>
                                                            <td>عدد المداخل</td>
                                                            <td>1</td>
                                                        </tr>
                                                        <tr>
                                                            <td>وصف الوحدة</td>
                                                            <td>سكني عائلات</td>
                                                        </tr>
                                                        <tr>
                                                            <td>الغرف/الفتحات عدد</td>
                                                            <td>4</td>
                                                        </tr>
                                                        <tr>
                                                            <td>عدد دورات المياه</td>
                                                            <td>2</td>
                                                        </tr>
                                                        <tr>
                                                            <td>نموذج الوحدة</td>
                                                            <td>امامى</td>
                                                        </tr>
                                                    </tbody>
                                                </table>  --}}
                                            </div>
                                        </div>
                                    </div>
                                    <div id="navpills-2" class="tab-pane fade">
                                        <div class="row">
                                            <div class="col-md-2">
                                                <div class="">
                                                    <input type="file" class="dropify" data-max-file-size="1M" />
                                                </div>
                                            </div>

                                            <div class="col-md-12 m-t-15">
                                                <div class="alert alert-warning">
                                                    <i class="fa fa-warning"></i>
                                                    لم يتم اضافة مستندات بعد...            
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="navpills-3" class="tab-pane fade">
                                        <div class="row">
                                             <div class="col-md-2">
                                                <div class="">
                                                    <input type="file" class="dropify" data-max-file-size="1M" />
                                                </div>
                                            </div>

                                            <div class="col-md-12 m-t-15">
                                                <div class="alert alert-warning">
                                                    <i class="fa fa-warning"></i>
                                                    لم يتم اضافة مستندات بعد...            
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="navpills-4" class="tab-pane fade">
                                        <div class="row">
                                            <div role="tabpanel" class="tab-pane active" id="customers">
                                                <table id="datatable-0" class="table table-striped table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th>رقم العقد</th>
                                                            <th>المستأجر</th>
                                                            <th>تاريخ بداية الإيجار</th>
                                                            <th>مدة العقد</th>
                                                            <th>قيمة العقد </th>
                                                            <th>الحالة</th>
                                                            <th>عرض</th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>
                                                        <tr>
                                                            <td>15049571</td>
                                                            <td>احمد محمد</td>
                                                            <td>2018-09-25م</td>
                                                            <td>6شهر</td>
                                                            <td>9000</td>
                                                            <td>فعال</td>
                                                            <td>عرض</td>
                                                        </tr>

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="navpills-5" class="tab-pane fade">
                                        <div class="row">
                                           <div class="col-md-12">
                                               <form method="post">
                                                    <div class="strong">أدخل نص الملاحظة</div>
                                                    <div class="m-t-10">
                                                        <textarea class="form-control" rows="5" name="note" placeholder=" أدخل نص الملاحظة هنا لإضافتها"></textarea>
                                                    </div>
                                                    <div class="m-t-10">
                                                        <button class="btn btn-primary pull-right"> اضافة</button>
                                                    </div>
                                                </form> 
                                           </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                </div>
                <!-- end row -->

@endsection
@section('script')
@endsection